
#include "Precompiled.h"
#include "MonoComm.h"

void MC_API MessageHandler(const VOID*, LPCSTR pszMessage)
{
	printf("%s", pszMessage);
}

void PrintStatus(MC_STATUS status)
{
	const char* pszStatus;

	switch (status)
	{
	case MC_S_ERROR:
		pszStatus = "Error";
		break;

	case MC_S_ERROR_ECU:
		pszStatus = "ECU error";
		break;

	case MC_S_ERROR_CONNECT:
		pszStatus = "Connection error";
		break;

	case MC_S_ERROR_CONNECT_PORT:
		pszStatus = "Comm port error";
		break;

	case MC_S_ERROR_CONNECT_ADAPTER:
		pszStatus = "Adapter timeout error";
		break;

	case MC_S_ERROR_CONNECT_ECU_ECHO:
		pszStatus = "ECU echo error";
		break;

	case MC_S_ERROR_CONNECT_BLOCK_INDEX:
		pszStatus = "Block index error";
		break;

	case MC_S_ERROR_CONNECT_ECU:
		pszStatus = "ECU timeout error";
		break;

	default:
		pszStatus = "?";
	}

	printf("\nMonoCommTest: status = %s\n", pszStatus);
}

int _tmain(int argc, _TCHAR* argv[])
{
	if (argc == 2 && ! stricmp(argv[1], "ta"))
	{
		printf("Test actuators, engine must be off (yes/no) ? ");
		char sz[32];
		fgets(sz, sizeof sz, stdin);

		if (stricmp(sz, "yes\n"))
			return 0;
	}

	MC_STATUS status = McConstruct(NULL, MessageHandler);

	if (status != MC_S_OK)
	{
		PrintStatus(status);

		return 1;
	}

	McSetMessagesLevel(MC_ML_LOG_2);

	LPSTR* ppszDescription;
	status = McConnect("COM1", 4800, 1, &ppszDescription);

	if (status != MC_S_OK)
	{
		PrintStatus(status);	

		McDestruct();		

		return 1;
	}

	for (int i = 0; ppszDescription[i] != NULL; ++ i)
	{
		if (! i)
			printf("\n");

		printf("Description %i: %s\n", i, ppszDescription[i]);

		McFree(ppszDescription[i]);
	}

	McFree(ppszDescription);

//	DWORD dwIdleInterval = McGetMaxIdleInterval();  // testing MaxIdleInterval
	DWORD dwIdleInterval = McGetMaxIdleInterval() / 2;

	for (int i = 0; i < 5; ++ i)
	{
		status = McIdle();

		if (status != MC_S_OK)
		{
			PrintStatus(status);

			McDisconnect();
			McDestruct();

			return 1;
		}

		Sleep(dwIdleInterval);
	}

	if (argc == 2)
	{
		if (! stricmp(argv[1], "gd"))
		{
			LPSTR* ppszDescription;
			status = McGetDescriptions(&ppszDescription);

			if (status != MC_S_OK)
			{
				PrintStatus(status);

				McDisconnect();
				McDestruct();

				return 1;
			}

			for (int i = 0; ppszDescription[i] != NULL; ++ i)
			{
				if (! i)
					printf("\n");

				printf("Description %i: %s\n", i, ppszDescription[i]);

				McFree(ppszDescription[i]);
			}

			McFree(ppszDescription);
		}
		else if (! stricmp(argv[1], "gf"))
		{
			DWORD dwCount;
			MC_FAULT* pfault;
			status = McGetFaults(&dwCount, &pfault);

			if (status != MC_S_OK)
			{
				PrintStatus(status);

				McDisconnect();
				McDestruct();

				return 1;
			}

			for (DWORD dwIndex = 0; dwIndex < dwCount; ++ dwIndex)
			{
				if (! dwIndex)
					printf("\n");

				printf("Fault %i: %05i\n", (int) dwIndex, (int) pfault[dwIndex].wCode);
			}

			McFree(pfault);
		}
		else if (! stricmp(argv[1], "cf"))
		{
			status = McClearFaults();

			if (status != MC_S_OK)
			{
				PrintStatus(status);

				McDisconnect();
				McDestruct();

				return 1;
			}

			printf("\nCleared faults\n");
		}
		else if (! stricmp(argv[1], "bs"))
		{
			BYTE abZones[10];
			
			for (int i = 0; i < 400; ++ i)
			{
				status = McGetBasicSettings(10, abZones);

				if (status != MC_S_OK)
				{
					PrintStatus(status);

					if (status == MC_S_ERROR_ECU)
						continue;

					McDisconnect();
					McDestruct();

					return 1;
				}

				if (! i)
					printf("\n");

				printf("Basic settings: %u %u %u %u %u %u %u %u %u %u\n",
					(unsigned) abZones[0], (unsigned) abZones[1],
					(unsigned) abZones[2], (unsigned) abZones[3],
					(unsigned) abZones[4], (unsigned) abZones[5],
					(unsigned) abZones[6], (unsigned) abZones[7],
					(unsigned) abZones[8], (unsigned) abZones[9]);
			}
		}
		else if (! stricmp(argv[1], "p"))
		{
			// Pinging as quick as possible

			for (int i = 0; i < 400; ++ i)
			{
				status = McIdle();

				if (status != MC_S_OK)
				{
					PrintStatus(status);

					McDisconnect();
					McDestruct();

					return 1;
				}
			}
		}
		else if (! stricmp(argv[1], "ta"))
		{
			while (true)
			{
				WORD wActuatorCode;
				status = McTestActuator(&wActuatorCode);

				if (status != MC_S_OK)
				{
					PrintStatus(status);

					if (status == MC_S_ERROR_ECU)
						continue;

					McDisconnect();
					McDestruct();

					return 1;
				}

				printf("Actuator %u\n", (unsigned) wActuatorCode);

				if (! wActuatorCode)
					break;

				Sleep(dwIdleInterval);

				for (int i = 0; i < 20; ++ i)
				{
					status = McIdle();

					if (status != MC_S_OK)
					{
						PrintStatus(status);

						McDisconnect();
						McDestruct();

						return 1;
					}

					Sleep(dwIdleInterval);
				}
			}				
		}
	}

	for (int i = 0; i < 5; ++ i)
	{
		status = McIdle();

		if (status != MC_S_OK)
		{
			PrintStatus(status);

			McDisconnect();
			McDestruct();

			return 1;
		}

		Sleep(dwIdleInterval);
	}

	McDisconnect();

	McDestruct();

	return 0;
}